/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.arl.util.ItemNBTHelper;

public class DataMaintainingRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final CraftingRecipe parent;
    private final Ingredient pullDataFrom;

    public DataMaintainingRecipe(CraftingRecipe parent, Ingredient pullDataFrom) {
        this.parent = parent;
        this.pullDataFrom = pullDataFrom;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.parent.m_5818_((Container)inv, worldIn);
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack stack = this.parent.m_5874_((Container)inv);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inInv = inv.m_8020_(i);
            if (!this.pullDataFrom.test(inInv)) continue;
            CompoundTag tag = ItemNBTHelper.getNBT((ItemStack)inInv);
            if (tag.m_128456_()) break;
            stack.m_41784_().m_128391_(tag);
            break;
        }
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return this.parent.m_8004_(width, height);
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.parent.m_8043_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.parent.m_6423_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.parent.m_6671_();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        return this.parent.m_7457_((Container)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.parent.m_7527_();
    }

    public boolean m_5598_() {
        return this.parent.m_5598_();
    }

    @Nonnull
    public String m_6076_() {
        return this.parent.m_6076_();
    }

    @Nonnull
    public ItemStack m_8042_() {
        return this.parent.m_8042_();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<DataMaintainingRecipe> {
        public Serializer() {
            this.setRegistryName("quark:maintaining");
        }

        @Nonnull
        public DataMaintainingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String trueType = GsonHelper.m_13906_((JsonObject)json, (String)"true_type");
            if (trueType.equals("quark:maintaining")) {
                throw new JsonSyntaxException("Recipe type circularity");
            }
            Ingredient pullFrom = Ingredient.m_43917_((JsonElement)json.get("copy_data_from"));
            RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation(trueType));
            if (serializer == null) {
                throw new JsonSyntaxException("Invalid or unsupported recipe type '" + trueType + "'");
            }
            Recipe parent = serializer.m_6729_(recipeId, json);
            if (!(parent instanceof CraftingRecipe)) {
                throw new JsonSyntaxException("Type '" + trueType + "' is not a crafting recipe");
            }
            CraftingRecipe craftingRecipe = (CraftingRecipe)parent;
            if (parent instanceof IShapedRecipe) {
                return new ShapedDataMaintainingRecipe(craftingRecipe, pullFrom);
            }
            return new DataMaintainingRecipe(craftingRecipe, pullFrom);
        }

        @Nonnull
        public DataMaintainingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient pullFrom = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String trueType = buffer.m_130136_(Short.MAX_VALUE);
            RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation(trueType));
            if (serializer == null) {
                throw new IllegalArgumentException("Invalid or unsupported recipe type '" + trueType + "'");
            }
            Recipe parent = serializer.m_8005_(recipeId, buffer);
            if (!(parent instanceof CraftingRecipe)) {
                throw new IllegalArgumentException("Type '" + trueType + "' is not a crafting recipe");
            }
            CraftingRecipe craftingRecipe = (CraftingRecipe)parent;
            if (parent instanceof IShapedRecipe) {
                return new ShapedDataMaintainingRecipe(craftingRecipe, pullFrom);
            }
            return new DataMaintainingRecipe(craftingRecipe, pullFrom);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull DataMaintainingRecipe recipe) {
            recipe.pullDataFrom.m_43923_(buffer);
            buffer.m_130072_(Objects.toString(recipe.parent.m_7707_().getRegistryName()), Short.MAX_VALUE);
            recipe.parent.m_7707_().m_6178_(buffer, (Recipe)recipe.parent);
        }
    }

    private static class ShapedDataMaintainingRecipe
    extends DataMaintainingRecipe
    implements IShapedRecipe<CraftingContainer> {
        private final IShapedRecipe<CraftingContainer> parent;

        public ShapedDataMaintainingRecipe(CraftingRecipe parent, Ingredient pullDataFrom) {
            super(parent, pullDataFrom);
            this.parent = (IShapedRecipe)parent;
        }

        public int getRecipeWidth() {
            return this.parent.getRecipeWidth();
        }

        public int getRecipeHeight() {
            return this.parent.getRecipeHeight();
        }
    }
}

